%
% Generate the figures and tables in Section 8.3.3 of the book.
%
% Dongrui WU (dongruiw@usc.edu), 5/12/2008

clc
clear all
close all

%% get the FOUs from the IA
[words,MFs,Cs]=getFOUsC8();

%% Construct the rulebase
subsetSurvey=[1 4 5 8 9]; %% indices of the five words used in the survey
antMFsSurvey=MFs(subsetSurvey,:);
CsSurvey=Cs(subsetSurvey); %% centers of centroid of the five words in the survey
names=['1. None to very little (NVL)'
    '         2. Some (S)        '
    '  3. Moderate amount (MOA)  '
    '    4. Large amount (LA)    '
    '   5. Maximum amount (MAA)  ']; %% names of the five words in the survey

namesA5={'NVL'     'S'     'MOA'     'LA'     'MAA'};
namesA9={'NVL'  'AB' 'SS'   'S'     'MOA' 'GA'  'CA'  'LA'  'MAA'};

histogram=[38 7 2 0 0
    33 11 3 0 0
    6 21 16 4 0
    0 12 28 8 1
    0 9 16 19 3
    31 11 4 1 0
    17 23 7 0 0
    0 19 19 8 1
    1 8 23 13 2
    0 7 17 21 2
    7 23 16 1 0
    5 22 20 0 0
    2 7 22 15 1
    1 4 13 17 12
    0 4 12 24 7
    7 13 21 6 0
    3 11 23 10 0
    0 3 18 18 8
    0 1 9 17 20
    1 2 6 11 27
    2 16 18 11 0
    2 9 22 13 1
    0 3 15 18 11
    0 1 7 17 22
    0 2 3 12 30]; %% survey histrogram

%% without pre-processing
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
for k=1:size(histogram,1)
    [YU,UU,YL,UL]=lwaPR(antMFsSurvey,[histogram(k,:)' histogram(k,:)'],2);
    subplot(6,5,k);
    fill([YU YL(length(YL):-1:1)],[UU UL(length(UL):-1:1)],[0.9 0.9 0.9]);
    hold on;
    plot([YU YL(length(UL):-1:1)],[UU UL(length(UL):-1:1)]);
    title([char(namesA5(ceil(k/5))) ' / ' char(namesA5(k-5*(ceil(k/5)-1)))],'fontsize',12);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
%saveas(gcf,'conMFsSurveyNoPP3.eps');

%% pre-processing
display('The histogram after preprocessing:');
histogram1=preprocessing(histogram,CsSurvey)

%% Compute the consequent FOUs and plot
conMFsC=zeros(length(histogram),9);
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
for k=1:length(histogram)
    [YU,UU,YL,UL]=lwaPR(antMFsSurvey,[histogram1(k,:)' histogram1(k,:)'],2);
    conMFsC(k,:)=[YU YL max(UL)];
    subplot(6,5,k);
    fill([YU YL(length(YL):-1:1)],[UU UL(length(UL):-1:1)],[0.9 0.9 0.9]);
    hold on;
    plot([YU YL(length(UL):-1:1)],[UU UL(length(UL):-1:1)]);
    if k-5*(ceil(k/5)-1)<=2
        text('Interpreter','latex','String',['$\tilde{Y}^{' num2str(ceil(k/5)) ','...
            num2str(k-5*(ceil(k/5)-1)) '}$'],'Position',[YU(3)+.8,.8]);
    else
        text('Interpreter','latex','String',['$\tilde{Y}^{' num2str(ceil(k/5)) ','...
            num2str(k-5*(ceil(k/5)-1)) '}$'],'Position',[YU(2)-3.5,.8]);
    end
    title([char(namesA5(ceil(k/5))) ' / ' char(namesA5(k-5*(ceil(k/5)-1)))],'fontsize',12);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'Fig8-7.eps');

%% Compute all possible cases
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',.8);
set(gcf,'DefaultaxesLineWidth',.35);
index=zeros(size(words,1),size(words,1));
for i=1:length(subsetSurvey)
    for j=1:length(subsetSurvey)
        antMFsSurvey((i-1)*5+j,1:18)=[MFs(subsetSurvey(i),:) MFs(subsetSurvey(j),:)];
    end
end
for i=1:9
    for k=1:size(words,1)
        [YU,UU,YL,UL]=PR([MFs(i,:) MFs(k,:)],antMFsSurvey,conMFsC);
        temp=[YU YL max(UL)];
        for j=1:size(words,1)
            sim(j)=Jaccard(temp,MFs(j,:));
        end
        [temp2,index(i,k)]=max(sim);
        subplot(11,9,9*(i-1)+k);
        fill(temp([1:4 8:-1:5 1]),[0 1 1 0 0 temp([9 9]) 0 0],[0.9 0.9 0.9]);
        hold on
        fill(MFs(index(i,k),[1:4 8:-1:5 1]),[0 1 1 0 0 MFs(index(i,k),[9 9]) 0 0],[0.9 0.9 0.9]);
        plot(temp([1:4 8:-1:5 1]),[0 1 1 0 0 temp([9 9]) 0 0],'w');
        plot(temp([1:4 8:-1:5 1]),[0 1 1 0 0 temp([9 9]) 0 0],'k--');
        plot(MFs(index(i,k),[1:4 8:-1:5 1]),[0 1 1 0 0 MFs(index(i,k),[9 9]) 0 0],'k');
        title([char(namesA9(i)) '/' char(namesA9(k)) '=>' char(namesA9(index(i,k)))],'fontsize',7);
        set(gca,'YTick',[]);
        set(gca,'XTick',[]);
        axis([0 10 0 1]);
    end
end
saveas(gcf,'Fig8-9.eps');


%% Plot only one case
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
i=7;
k=2;
[YU,UU,YL,UL]=PR([MFs(i,:) MFs(k,:)],antMFsSurvey,conMFsC);
temp=[YU YL max(UL)];
for j=1:size(words,1)
    sim(j)=Jaccard(temp,MFs(j,:));
end
[temp2,index(i,k)]=max(sim);
subplot(5,3,1);
fill(temp([1:4 8:-1:5 1]),[0 1 1 0 0 temp([9 9]) 0 0],[0.9 0.9 0.9]);
hold on
fill(MFs(index(i,k),[1:4 8:-1:5 1]),[0 1 1 0 0 MFs(index(i,k),[9 9]) 0 0],[0.9 0.9 0.9]);
plot(temp([1:4 8:-1:5 1]),[0 1 1 0 0 temp([9 9]) 0 0],'k--');
plot(MFs(index(i,k),[1:4 8:-1:5 1]),[0 1 1 0 0 MFs(index(i,k),[9 9]) 0 0],'k');
title(namesA9(index(i,k)),'fontsize',12);
set(gca,'YTick',[]);
set(gca,'XTick',[]);
axis([0 10 0 1]);
saveas(gcf,'Fig8-8.eps');
sim


%% individual's opinion
individual=[3 3 4 5 5 6 7 8 9];
%% compute the output FOUs when touching=5
touching=5;
for i=1:size(words,1)
    similarity(i)=round(100*Jaccard(MFs(index(touching,i),:),MFs(individual(i),:)))/100;
end



